#ifndef ADT8840m_H_H 
#define ADT8840m_H_H

/*
#include <WINNT.H>
#include <winsock.h>
#include <afxsock.h>
*/

#define INT8U  unsigned char
#define INT16U unsigned short  
#define INT16S short  int
#define INT32U unsigned long 
#define	MAXCH	    4
#define FS_DIRNAME_MAX    256

/////////////////////////////////////////////////////////////////////////////////

typedef struct
{//File system parameter structure
	float	fHomeStartv[MAXCH];		//the start speed to origin
	float	fHomeSpeed[MAXCH];		//the Maximum Speed to origin
	float	fHomeAccTime[MAXCH];	//the Acceleration time to origin
	
	float	fHomelSpeed[MAXCH];		//Back to the origin search speed
	float	fHomelRange[MAXCH];		//Back to the origin Search Range
	
	float	fStartv[MAXCH];			//Initial speed of processing
	float	fSpeed[MAXCH];			//Processing speed drive
	float	fAccTime[MAXCH];		//Processing speed up the time
	
	INT32U	lPulseMm[MAXCH];		//Pulse equivalent
	
	INT8U	home[MAXCH];			//Origin of the signal is valid
	INT8U	home_logic[MAXCH];		//Origin of the signal level
	INT8U	ucZi[MAXCH];  			//Encoder Z -phase is valid
	INT8U	Zi_logic[MAXCH];  		//With the effective level Z
	INT8U	home_setup[MAXCH];		//Origin of the axes implementation back to the conditions
	INT8U	home_step[MAXCH];		//Steps back to the origin of all axes , values of ( 0-3 )
	
	INT8U	limit_pos[MAXCH];		//Positive direction limit effective
	INT8U	limit_neg[MAXCH];		//Effectively limit the negative direction
	INT8U	limit_logic[MAXCH];		//Limit logic
	
	INT8U	pulse_mode[MAXCH];		//Pulse mode
	INT8U	pulse_logic[MAXCH];		//Pulse Logic
	INT8U	dir_logic[MAXCH];		//Direction signal logic

	INT8U	en_alarm[MAXCH];		//Servo alarm signal effectively
	INT8U	alarm_logic[MAXCH];		//Servo alarm signal logic
	INT32U	alarm_out;				//Alarm output signal , the specified output points ( 0-21 )
	INT32U	alarm_out_logic;		//Alarm output signal logic
	INT32U	en_broadcast;			//Broadcast messages when the network connection is valid
}SYSPARA;


//-------------------------------------------------//
//             Device interface , parameter type               //
//-------------------------------------------------//
void _stdcall DeviceAddr_init(void);
int _stdcall TCP_Conn(char *ip_addr,char *mac_addr,int *err);

void _stdcall Close_netconn(int dev_num);

void _stdcall Close_all(void);

unsigned int _stdcall Get_sock(int dev_num);

//----------------------------------------------------//
//              Driver status check function                     //
//----------------------------------------------------//

int  _stdcall adt8840a_get_status(int dev_num,int axis,int *value);

int  _stdcall adt8840a_get_inp_status(int dev_num,int *value);

int  _stdcall adt8840a_get_int_status(int dev_num,int *value);

//----------------------------------------------------//
//               Movement parameter setting function                   //
//----------------------------------------------------//

int  _stdcall adt8840a_set_pulse_mode(int dev_num,int axis,int value,int logic,int dir_logic);

int  _stdcall adt8840a_set_stop0_mode(int dev_num,int axis,int value,int logic);

int  _stdcall adt8840a_set_stop1_mode(int dev_num,int axis,int value,int logic);

int  _stdcall adt8840a_set_limit_mode(int dev_num,int axis,int v1,int v2,int logic);

int  _stdcall adt8840a_set_acc(int dev_num,int axis,long value);

int  _stdcall adt8840a_set_startv(int dev_num,int axis,long value);

int  _stdcall adt8840a_set_speed(int dev_num,int axis,long value);

int  _stdcall adt8840a_set_command_pos(int dev_num,int axis,long value);

int  _stdcall adt8840a_set_actual_pos(int dev_num,int axis,long Value);

//----------------------------------------------------//
//               Movement parameter setting function                   //
//----------------------------------------------------//
int  _stdcall adt8840a_get_command_pos(int dev_num,int axis,long *pos);

int  _stdcall adt8840a_get_actual_pos( int dev_num,int axis,long *pos);

int  _stdcall adt8840a_get_speed( int dev_num,int axis,long *speed);

int  _stdcall adt8840a_all_speed( int dev_num,long speed[]);

int  _stdcall adt8840a_all_command_pos( int dev_num,long pos[]);

int  _stdcall adt8840a_all_actual_pos( int dev_num,long pos[]);

//----------------------------------------------------//
//                   Driving function                        //
//----------------------------------------------------//

int  _stdcall adt8840a_pmove(int dev_num,int axis,long pulse);

int  _stdcall adt8840a_pmove2(int dev_num,int axis1,int axis2,long pulse1,long pulse2);

int  _stdcall adt8840a_pmove3(int dev_num,int axis1,int axis2,int axis3,long pulse1,long pulse2,long pulse3);

int  _stdcall adt8840a_pmove4(int dev_num,long pulse1,long pulse2,long pulse3,long pulse4);

int  _stdcall adt8840a_continue_move(int dev_num,int axis,int dir);

int  _stdcall adt8840a_dec_stop(int dev_num,int axis);

int  _stdcall adt8840a_sudden_stop(int dev_num,int axis);

int  _stdcall adt8840a_inp_move2(int dev_num,int axis1,int axis2,long pulse1,long pulse2);

int  _stdcall adt8840a_inp_move3(int dev_num,int axis1,int axis2,int axis3,long pulse1,long pulse2,long pulse3);

int  _stdcall adt8840a_inp_move4(int dev_num,long pulse1,long pulse2,long pulse3,long pulse4);

int  _stdcall adt8840a_arc(int dev_num,int dir,int axis1,int axis2,long x,long y,long i,long j);

int  _stdcall adt8840a_go_home(int dev_num);

int _stdcall adt8840a_stop_sel(int dev_num,char axis[4],int mode);

int  _stdcall adt8840a_stop_all(int dev_num);

int  _stdcall adt8840a_pause(int dev_num);

int  _stdcall adt8840a_Resume(int dev_num);

//-------------------------------------------------//
//               Digital input output class            //
//-------------------------------------------------//  

int  _stdcall adt8840a_read_bit(int dev_num,int number,int *value);

int  _stdcall adt8840a_write_bit(int dev_num,int number,int value);

int  _stdcall adt8840a_sudden_write_bit(int dev_num,int number,int value);

int  _stdcall adt8840a_read_8bit(int dev_num,int ios,int *value);

//------------------------------------------------//
//               Hardware cache                   //
//------------------------------------------------//
int  _stdcall adt8840a_reset_fifo(int dev_num);

int  _stdcall adt8840a_read_fifo(int dev_num,unsigned short *value);

int  _stdcall adt8840a_fifo_inp_move1(int dev_num,int axis1,long pulse1,long speed);

int  _stdcall adt8840a_fifo_inp_move2(int dev_num,int axis1,int axis2,long pulse1,long pulse2,long speed);

int  _stdcall adt8840a_fifo_inp_move3(int dev_num,int axis1,int axis2,int axis3,long pulse1,long pulse2,long pulse3,long speed);

int  _stdcall adt8840a_fifo_inp_move4(int dev_num,long pulse1,long pulse2,long pulse3,long pulse4,long speed);

int _stdcall adt8840a_get_buff_depth(int dev_num,int *buff_depth);

int _stdcall adt8840a_clear_buff_depth(int dev_num);

int  _stdcall adt8840a_set_buff_mode(int dev_num,int buffmode);


//-------------------------------------------------//
//             System parameters class             //
//-------------------------------------------------//
/////////////////////////////////////////////////////////////////////////////////
int  _stdcall adt8840a_FS_Remove(int dev_num,const char *pFileName);

int _stdcall Uart_show(int dev_num,unsigned int on_off);

int _stdcall adt8840a_Net_Setup(int dev_num,char *IP,char *MASK,char *Gateway,char *MAC);

int  _stdcall adt8840a_set_speed_mode(int dev_num,int mode);

int  _stdcall adt8840a_set_pulsemm(int dev_num,int axis,int PulseMm);

int  _stdcall adt8840a_get_pulsemm(int dev_num,int axis,int *PulseMm);

int  _stdcall adt8840a_upload_sysfile(int dev_num,int mode,char *file,SYSPARA  *syspara);

int  _stdcall adt8840a_download_sysfile(int dev_num,int mode,SYSPARA  *syspara,char *file);

int _stdcall adt8840a_wait_delay(int dev_num,int delay);

int _stdcall adt8840a_wait_inport_l(int dev_num,int inport);

int _stdcall adt8840a_wait_inport_h(int dev_num,int inport);

//------------------------------------------------//
//                G Code Processing                //
//------------------------------------------------//
int  _stdcall adt8840a_get_sys_status( int dev_num,int *ilde,int *G_status,int *lock_stop);

int  _stdcall adt8840a_download_gfile(int dev_num);

int _stdcall adt8840a_ram_pre(int dev_num);

int  _stdcall adt8840a_run_gfile(int dev_num);

char* _stdcall adt8840a_upload_gfile(int dev_num,int *err,int *code_len);

int  _stdcall adt8840a_g_code(int dev_num,char *G_code);

int  _stdcall adt8840a_download_gcode(int dev_num,char *g_code,int code_len);

int  _stdcall adt8840a_run_gcode(int dev_num);

int  _stdcall adt8840a_buff_block_status(int dev_num,int *status);

int _stdcall adt8840a_get_gcode_depth(int dev_num,int *buff_depth,char *gcode);

void _stdcall adt8840a_dll_free(void* data);

#endif



